/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockStepDialog;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWCallStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWComponentStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWDummyStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWLaunchStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWQueueUserStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWSystemStepPropPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWOccurrenceNumberRenderer;
import filenet.vw.toolkit.runtime.table.VWStepNParticipantRenderer;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWStepPropPanel
extends JPanel
implements ChangeListener,
ItemSelectable,
ItemListener,
IVWPropertyChangeSource,
IVWPropertyChangeListener {
    static final int CHANGED_NONE = 0;
    static final int CHANGED_PARTICIPANT = 1;
    static final int CHANGED_VIEW = 2;
    static final int CHANGED_OCCURRENCE = 3;
    static final int CHANGED_STEP = 4;
    static final int CHANGED_MAP = 5;
    protected Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private boolean m_trackerDataInitialized = false;
    private boolean m_bInitialized = false;
    VWQueueUserStepPropPanel m_queueStepPanel = null;
    VWLaunchStepPropPanel m_launchStepPanel = null;
    VWDummyStepPropPanel m_dummyStepPanel = null;
    VWCallStepPropPanel m_callStepPanel = null;
    VWSystemStepPropPanel m_systemStepPanel = null;
    VWBaseStepPropPanel m_selectedPanel = null;
    VWComponentStepPropPanel m_componentStepPanel = null;
    private Vector m_steps = null;
    private VWTrkStep m_selectedStep = null;
    private Vector m_selectedSteps = null;
    private VWMapNode m_mapNode = null;
    private int m_selectedStepIndex = 0;
    private boolean m_bRuntime;
    private String m_instructions = null;
    private int m_lockStatus = 1;
    private boolean m_bDirty = false;
    private JPanel m_namePanel;
    private JComboBox m_nameCombo = null;
    private JLabel m_occurrenceLabel;
    private JComboBox m_occurrenceCombo;
    private DefaultComboBoxModel m_occurrenceModel;
    private VWOccurrenceNumberRenderer m_occurrenceNumberRenderer = new VWOccurrenceNumberRenderer();
    private VWStepNParticipantRenderer m_stepAndParticipantRenderer = new VWStepNParticipantRenderer();
    protected ItemListener m_selectListeners = null;
    protected boolean m_bDisplayUpdated = false;
    private int m_updatingCount = 0;
    private Object m_countSync = new Object();
    protected int m_selectionChanged = 0;
    protected boolean m_bDataUpdated = false;

    public VWStepPropPanel(Frame parentFrame, VWTrkDataModel trackerDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = trackerDataModel;
        VWLockStepDialog.setDontAskAgain(false);
        this.m_queueStepPanel = new VWQueueUserStepPropPanel(this, parentFrame);
        this.updatePanelsComponentOrientation(this.m_queueStepPanel);
        this.m_queueStepPanel.setVisible(false);
        this.m_launchStepPanel = new VWLaunchStepPropPanel(this, parentFrame);
        this.updatePanelsComponentOrientation(this.m_launchStepPanel);
        this.m_launchStepPanel.setVisible(false);
        this.m_dummyStepPanel = new VWDummyStepPropPanel(this, parentFrame);
        this.updatePanelsComponentOrientation(this.m_dummyStepPanel);
        this.m_dummyStepPanel.setVisible(false);
        this.m_callStepPanel = new VWCallStepPropPanel(this, parentFrame);
        this.updatePanelsComponentOrientation(this.m_callStepPanel);
        this.m_callStepPanel.setVisible(false);
        this.m_systemStepPanel = new VWSystemStepPropPanel(this, parentFrame);
        this.updatePanelsComponentOrientation(this.m_systemStepPanel);
        this.m_systemStepPanel.setVisible(false);
        this.m_componentStepPanel = new VWComponentStepPropPanel(this, parentFrame);
        this.updatePanelsComponentOrientation(this.m_componentStepPanel);
        this.m_componentStepPanel.setVisible(false);
        this.setupLayout();
    }

    void initialize() {
        if (this.isTrackerDataInitialized()) {
            this.initNamePanel();
            this.m_launchStepPanel.initialize();
            this.m_queueStepPanel.initialize();
            this.m_dummyStepPanel.initialize();
            this.m_callStepPanel.initialize();
            this.m_systemStepPanel.initialize();
            this.m_componentStepPanel.initialize();
            this.selectStep(null, false);
            this.m_nameCombo.setSelectedIndex(-1);
            VWPropertyChangeNotifier.addPropertyChangeListener(this);
            this.m_bInitialized = true;
        }
    }

    private void initNameComboModel() {
        this.m_bInitialized = false;
        VWTrkStep launchStep = null;
        this.m_steps = this.m_trackerDataModel.getSelectedMapStepCollection();
        if (this.m_steps != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_nameCombo.getModel();
            this.m_nameCombo.setModel(new DefaultComboBoxModel());
            model.removeAllElements();
            for (int i = 0; i < this.m_steps.size(); ++i) {
                VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
                if (step.isLaunchStep()) {
                    launchStep = step;
                }
                String stepName = VWStepNParticipantRenderer.toString(this.m_steps.elementAt(i));
                String name = null;
                boolean bInserted = false;
                for (int j = 0; j < model.getSize(); ++j) {
                    name = VWStepNParticipantRenderer.toString(model.getElementAt(j));
                    if (VWStringUtils.compareIgnoreCase(stepName, name) >= 0) continue;
                    model.insertElementAt(this.m_steps.elementAt(i), j);
                    bInserted = true;
                    break;
                }
                if (bInserted) continue;
                model.addElement(this.m_steps.elementAt(i));
            }
            this.m_nameCombo.setModel(model);
        }
        this.m_bInitialized = true;
    }

    public boolean isTrackerDataInitialized() {
        if (!this.m_trackerDataInitialized) {
            this.m_trackerDataInitialized = this.m_trackerDataModel != null && this.m_trackerDataModel.getInitState() == 6;
        }
        return this.m_trackerDataInitialized;
    }

    protected void setupLayout() {
        this.setLayout(new BorderLayout());
        this.setupNamePanel();
        this.add((Component)this.m_namePanel, "First");
    }

    private void setupNamePanel() {
        GridBagConstraints c = new GridBagConstraints();
        this.m_namePanel = new JPanel();
        this.m_namePanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 6);
        c.fill = 2;
        c.weightx = 0.0;
        this.m_namePanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_name)), c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_nameCombo = new JComboBox(new DefaultComboBoxModel());
        this.m_stepAndParticipantRenderer = new VWStepNParticipantRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
                if (value == null) {
                    ((JLabel)component).setText(VWResource.s_noOrMultiStepsSelected);
                }
                return component;
            }
        };
        this.m_nameCombo.setRenderer(this.m_stepAndParticipantRenderer);
        this.m_nameCombo.setPreferredSize(new Dimension(40, 20));
        this.m_namePanel.add((Component)this.m_nameCombo, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 0, 0, 6);
        c.fill = 2;
        c.weightx = 0.0;
        this.m_occurrenceLabel = new JLabel(VWResource.s_label.toString(VWResource.s_occurrence));
        this.m_namePanel.add((Component)this.m_occurrenceLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_occurrenceModel = new DefaultComboBoxModel();
        this.initOccurrenceModel();
        this.m_occurrenceCombo = new JComboBox(this.m_occurrenceModel);
        this.m_occurrenceCombo.setRenderer(this.m_occurrenceNumberRenderer);
        this.m_occurrenceCombo.setPreferredSize(new Dimension(60, 20));
        this.m_namePanel.add((Component)this.m_occurrenceCombo, c);
    }

    private void initNamePanel() {
        this.initNameComboModel();
        this.m_nameCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWTrkStep step;
                Object obj = VWStepPropPanel.this.m_nameCombo.getSelectedItem();
                if (obj == null && VWStepPropPanel.this.getSelectedStep() != null) {
                    VWStepPropPanel.this.selectStep(null, false);
                } else if (obj != null && obj instanceof VWTrkStep && (step = (VWTrkStep)obj) != VWStepPropPanel.this.getSelectedStep()) {
                    VWStepPropPanel.this.selectStep(step, VWStepPropPanel.this.m_bInitialized);
                }
            }
        });
        this.m_occurrenceCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (VWStepPropPanel.this.isUpdating()) {
                    return;
                }
                int index = VWStepPropPanel.this.m_occurrenceCombo.getSelectedIndex();
                if (index != -1 && index != VWStepPropPanel.this.getSelectedOccurrenceIndex()) {
                    VWStepPropPanel.this.getSelectedStep().setSelectedOccurrenceIndex(index);
                    VWStepPropPanel.this.setSelectionChanged(3);
                    VWStepPropPanel.this.init();
                    VWStepPropPanel.this.notifyPropertyChange();
                }
            }
        });
    }

    public void itemStateChanged(ItemEvent e) {
        int stepCount;
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (e.getID() == 100) {
            this.initNameComboModel();
            this.setSelectionChanged(5);
        }
        ItemSelectable itemSelectable = e.getItemSelectable();
        Object[] objects = itemSelectable.getSelectedObjects();
        Object obj = null;
        this.m_selectedSteps = new Vector();
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null || !(objects[i] instanceof VWMapNode)) continue;
                this.m_selectedSteps.addElement(objects[i]);
            }
        }
        if ((stepCount = this.m_selectedSteps.size()) == 1) {
            VWMapNode mapNode = (VWMapNode)this.m_selectedSteps.elementAt(0);
            VWTrkStep step = this.findStep(mapNode.getStepId());
            this.selectStep(step, false);
            this.m_nameCombo.setSelectedItem(step);
        } else {
            this.selectStep(null, false);
            this.m_nameCombo.setSelectedIndex(-1);
        }
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    protected void notifySelectListeners() {
        ItemEvent event = new ItemEvent(this, 0, this, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    protected void notifySelectListeners(ItemEvent event) {
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public Object[] getSelectedObjects() {
        if (!this.isTrackerDataInitialized()) {
            return null;
        }
        Object[] objects = null;
        if (this.getSelectedStep() != null) {
            objects = new Object[]{this.m_selectedStep.getMapNode()};
        }
        return objects;
    }

    protected void selectStep(VWTrkStep step, boolean bNotify) {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (step != this.getSelectedStep()) {
            VWBaseStepPropPanel selectedPanel = null;
            this.setSelectedStep(step);
            if (step != null) {
                selectedPanel = step.isLaunchStep() ? this.m_launchStepPanel : (step.isQueueStep() || step.isUserStep() ? this.m_queueStepPanel : (step.isCallStep() ? this.m_callStepPanel : (step.isSystemStep() ? this.m_systemStepPanel : (step.isComponentStep() ? this.m_componentStepPanel : this.m_dummyStepPanel))));
            } else if (this.m_selectedSteps == null || this.m_selectedSteps.size() == 0) {
                // empty if block
            }
            if (this.m_selectedPanel != null) {
                this.remove(this.m_selectedPanel);
                this.m_selectedPanel.setVisible(false);
            }
            this.m_selectedPanel = selectedPanel;
            this.updateDataWithSelectedStep();
            if (this.m_selectedPanel != null) {
                this.add((Component)this.m_selectedPanel, "Center");
                this.m_selectedPanel.setVisible(true);
            } else {
                this.m_nameCombo.setSelectedIndex(-1);
            }
            this.updateUI();
            if (bNotify) {
                this.notifySelectListeners();
            }
        }
    }

    protected VWTrkStep findStep(int stepId) {
        if (!this.isTrackerDataInitialized() || this.m_steps == null) {
            return null;
        }
        for (int i = 0; i < this.m_steps.size(); ++i) {
            VWTrkStep step = (VWTrkStep)this.m_steps.elementAt(i);
            if (step.getStepId() != stepId) continue;
            return step;
        }
        return null;
    }

    public ImageIcon getLockedStatusIcon() {
        if (!this.isTrackerDataInitialized()) {
            return null;
        }
        if (this.m_selectedStep == null) {
            return null;
        }
        return this.m_selectedStep.getLockedStatusIcon();
    }

    VWTrkDataModel getDataModel() {
        return this.m_trackerDataModel;
    }

    public Vector getItemsChanged() {
        if (!this.isTrackerDataInitialized()) {
            return null;
        }
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        steps.addElement(this.m_selectedStep);
        return steps;
    }

    public Vector getSteps() {
        return this.m_steps;
    }

    public int getSelectedOccurrenceIndex() {
        if (!this.isTrackerDataInitialized()) {
            return -1;
        }
        if (this.m_selectedStep != null) {
            return this.m_selectedStep.getSelectedOccurrenceIndex();
        }
        return -1;
    }

    public VWTrkStepOccurrence getSelectedOccurrence() {
        if (this.isTrackerDataInitialized() && this.m_selectedStep != null) {
            return this.m_selectedStep.getSelectedOccurrence();
        }
        return null;
    }

    public VWTrkStep getSelectedStep() {
        return this.m_selectedStep;
    }

    public VWMapNode getMapNode() {
        if (this.m_selectedStep != null) {
            return this.m_selectedStep.getMapNode();
        }
        return null;
    }

    public VWStepDefinition getStepDefinition() {
        if (this.m_selectedStep != null) {
            return this.m_selectedStep.getStepDefinition();
        }
        return null;
    }

    public VWCompoundStepDefinition getCompoundStepDefinition() {
        if (this.m_selectedStep != null) {
            return this.m_selectedStep.getCompoundStepDefinition();
        }
        return null;
    }

    public Vector getSelectedSteps() {
        return this.m_selectedSteps;
    }

    protected void setSelectedStep(VWTrkStep step) {
        this.m_selectedStep = step;
        if (step != null) {
            this.m_bRuntime = this.getSelectedOccurrence() != null;
            this.m_mapNode = step.getMapNode();
            this.m_instructions = this.m_mapNode.getDescription();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        this.m_selectedPanel.stateChanged(e);
    }

    protected void setDataUpdated(boolean bUpdated) {
        this.m_bDataUpdated = bUpdated;
    }

    protected void initData() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (this.isDataUpdated()) {
            return;
        }
        if (this.m_selectedPanel != null) {
            this.m_selectedPanel.initData();
        }
        this.setDataUpdated(true);
    }

    protected boolean isDataUpdated() {
        return this.m_bDataUpdated;
    }

    protected boolean isDisplayUpdated() {
        return this.m_bDisplayUpdated;
    }

    protected void setDisplayUpdated(boolean bUpdated) {
        this.m_bDisplayUpdated = bUpdated;
    }

    protected void setSelectionChanged(int flag) {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (this.isDataUpdated() && this.isDisplayUpdated()) {
            this.m_selectionChanged = flag;
        } else if (flag > this.m_selectionChanged) {
            this.m_selectionChanged = flag;
        }
        boolean bUpdated = flag == 0;
        this.setDataUpdated(bUpdated);
        this.setDisplayUpdated(bUpdated);
        this.m_queueStepPanel.propagateSelectionChanged(flag);
        this.m_launchStepPanel.propagateSelectionChanged(flag);
        this.m_dummyStepPanel.propagateSelectionChanged(flag);
        this.m_callStepPanel.propagateSelectionChanged(flag);
        this.m_systemStepPanel.propagateSelectionChanged(flag);
        this.m_componentStepPanel.propagateSelectionChanged(flag);
    }

    protected int getSelectionChanged() {
        return this.m_selectionChanged;
    }

    boolean isSelectionChanged() {
        if (this.m_selectionChanged == 0) {
            return false;
        }
        return !this.m_bDataUpdated || !this.m_bDisplayUpdated;
    }

    public void init() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (!this.isSelectionChanged()) {
            return;
        }
        this.initData();
        this.updateDisplay();
        this.setSelectionChanged(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (this.isDisplayUpdated()) {
            return;
        }
        try {
            this.setUpdating();
            switch (this.getSelectionChanged()) {
                case 4: 
                case 5: {
                    this.initOccurrenceModel();
                    this.m_occurrenceCombo.setVisible(this.m_bRuntime);
                    this.m_occurrenceLabel.setVisible(this.m_bRuntime);
                    if (!this.m_bRuntime) break;
                    this.m_occurrenceCombo.setSelectedIndex(this.getSelectedOccurrenceIndex());
                }
            }
            if (this.m_selectedPanel != null) {
                this.m_selectedPanel.updatePanelDisplay();
            }
            this.setDisplayUpdated(true);
        }
        finally {
            this.doneUpdating();
        }
    }

    protected void updateDataWithSelectedStep() {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        this.m_bRuntime = false;
        this.m_bRuntime = this.getSelectedOccurrence() != null;
        this.m_occurrenceModel.removeAllElements();
        if (this.m_selectedPanel != null) {
            this.m_selectedPanel.updateDataWithSelectedStep();
        }
        this.setSelectionChanged(4);
        this.init();
    }

    protected boolean isRuntimeStep() {
        return this.m_bRuntime;
    }

    private void initOccurrenceModel() {
        Vector occurrences;
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        if (this.getSelectedStep() != null && (occurrences = this.getSelectedStep().getOccurrenceCollection()) != null && occurrences.size() > 0) {
            this.m_occurrenceModel.removeAllElements();
            if (occurrences == null) {
                return;
            }
            for (int index = 0; index < occurrences.size(); ++index) {
                this.m_occurrenceModel.addElement(occurrences.elementAt(index));
            }
        }
    }

    public void notifyPropertyChange() {
        VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, 702));
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        if (!this.isTrackerDataInitialized()) {
            return;
        }
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 702: {
                    if (source == this) break;
                    if (this.getSelectedStep() == null) {
                        return;
                    }
                    int index = this.getSelectedOccurrenceIndex();
                    if (index < 0 || this.m_occurrenceModel == null || index >= this.m_occurrenceModel.getSize()) break;
                    this.m_occurrenceCombo.setSelectedIndex(index);
                    this.getSelectedStep().setSelectedOccurrenceIndex(index);
                    this.setSelectionChanged(3);
                    this.init();
                }
            }
        }
        if (this.m_selectedPanel != null) {
            this.m_selectedPanel.propertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            return this.m_updatingCount > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            ++this.m_updatingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doneUpdating() {
        Object object = this.m_countSync;
        synchronized (object) {
            if (this.m_updatingCount > 0) {
                --this.m_updatingCount;
            }
        }
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        if (this.m_queueStepPanel != null) {
            this.m_queueStepPanel.removeReferences();
            this.m_queueStepPanel = null;
        }
        if (this.m_launchStepPanel != null) {
            this.m_launchStepPanel.removeReferences();
            this.m_launchStepPanel = null;
        }
        if (this.m_dummyStepPanel != null) {
            this.m_dummyStepPanel.removeReferences();
            this.m_dummyStepPanel = null;
        }
        if (this.m_callStepPanel != null) {
            this.m_callStepPanel.removeReferences();
            this.m_callStepPanel = null;
        }
        if (this.m_systemStepPanel != null) {
            this.m_systemStepPanel.removeReferences();
            this.m_systemStepPanel = null;
        }
        this.m_selectedPanel = null;
        if (this.m_steps != null) {
            this.m_steps.removeAllElements();
            this.m_steps = null;
        }
        this.m_selectedStep = null;
        if (this.m_selectedSteps != null) {
            this.m_selectedSteps.removeAllElements();
            this.m_selectedSteps = null;
        }
        this.m_mapNode = null;
        this.m_instructions = null;
        if (this.m_namePanel != null) {
            this.m_namePanel.removeAll();
            this.m_namePanel = null;
        }
        if (this.m_nameCombo != null) {
            this.m_nameCombo.removeAllItems();
            this.m_nameCombo = null;
        }
        this.m_occurrenceLabel = null;
        this.m_occurrenceCombo = null;
        this.m_occurrenceModel = null;
        this.m_stepAndParticipantRenderer = null;
        this.m_occurrenceNumberRenderer = null;
        this.m_selectListeners = null;
        this.removeAll();
        this.m_countSync = null;
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
    }

    protected void updatePanelsComponentOrientation(JPanel canvasPanel) {
        try {
            if (canvasPanel != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                canvasPanel.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

